﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Graphic.Sample1
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern IntPtr GetDC(IntPtr hWnd);

        [DllImport("user32.dll")]
        public static extern IntPtr GetWindowDC(IntPtr hWnd);

        [DllImport("gdi32.dll")]
        public static extern bool DeleteDC(IntPtr hDC);

        [DllImport("user32.dll")]
        public static extern bool ReleaseDC(IntPtr hWnd, IntPtr hDC);

        [DllImport("gdi32.dll")]
        public static extern bool MoveToEx(IntPtr hDC, int x, int y, IntPtr lpPoint);

        [Flags]
        public enum PenStyle
        {
            PS_Solid = 0,
            PS_Dash = 1,
            PS_Dot = 2,
            PS_DashDot = 3,
            PS_DashDotDot = 4,
            PS_Null = 5,
            PS_InSideFrame = 6,
            PS_UserStyle = 7,
            PS_Alternate = 8,
            PS_StyleMask = 0x0000000F,

            PS_EndCapRound = 0x00000000,
            PS_EndCapSquare = 0x00000100,
            PS_EndCapFlat = 0x00000200,
            PS_EndCapMask = 0x00000F00,

            PS_JoinRound = 0x00000000,
            PS_JoinBevel = 0x00001000,
            PS_JoinMiter = 0x00002000,
            PS_JoinMask = 0x0000F000,

            PS_CosMetric = 0x00000000,
            PS_GeoMetric = 0x00010000,
            PS_TypeMask = 0x000F0000
        }

        [DllImport("gdi32.dll")]
        public static extern IntPtr CreatePen(PenStyle penStyle, int nWidth, int penColor);

        [DllImport("gdi32.dll")]
        public static extern IntPtr SelectObject(IntPtr hDC, IntPtr hObject);

        [DllImport("gdi32.dll")]
        public static extern bool DeleteObject(IntPtr hObject);

        [DllImport("gdi32.dll")]
        public static extern bool LineTo(IntPtr hDC, int nXEnd, int nYEnd);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonDraw_Click(object sender, EventArgs e)
        {
            IntPtr hDC = GetDC(this.Handle);

            Color penColor = Color.Red;
            const int penWidth = 0x3;

            IntPtr pen = CreatePen(PenStyle.PS_Solid | PenStyle.PS_GeoMetric | PenStyle.PS_EndCapRound, penWidth, ColorTranslator.ToWin32(penColor));

            IntPtr oldPen = SelectObject(hDC, pen);

            int height = this.ClientSize.Height - 10;
            int width = this.ClientSize.Width - 10;

            MoveToEx(hDC, width / 2, 10, IntPtr.Zero);
            LineTo(hDC, width, height);
            LineTo(hDC, 10, height);
            LineTo(hDC, width / 2, 10);

            DeleteObject(SelectObject(hDC, oldPen));
            SelectObject(hDC, oldPen);
            DeleteDC(hDC);
        }
    }
}